/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations;

import de.codingair.tradesystem.lib.codingapi.particles.Particle;
import de.codingair.tradesystem.lib.codingapi.particles.animations.Animation;
import de.codingair.tradesystem.lib.codingapi.particles.animations.movables.LocationMid;
import de.codingair.tradesystem.lib.codingapi.particles.animations.movables.MovableMid;
import de.codingair.tradesystem.lib.codingapi.tools.HitBox;
import de.codingair.tradesystem.lib.jetbrains.annotations.Nullable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public abstract class CustomAnimation
extends Animation {
    public static final int MAX_SPEED = 10;
    public static final int MIN_SPEED = 1;
    static final double CALCULATE_RADIUS = 2.0;
    static final double MAX_STANDARD_RADIUS = 3.0;
    private static final int MAX_TICKS = 10;
    private final List<List<Location>> CACHE = new ArrayList<List<Location>>();
    private final double radius;
    private final double height;
    private final MovableMid mid;
    private final Location zero;
    private int playId = 0;
    private int xRotation = 0;
    private int yRotation = 0;
    private int zRotation = 0;
    private double sinX;
    private double sinY;
    private double sinZ;
    private double cosX;
    private double cosY;
    private double cosZ;
    private boolean calculateSinCos = true;
    private int skipped = 0;
    private int delay;
    private int speed = 0;
    private de.codingair.tradesystem.lib.codingapi.particles.utils.Color color;
    private int rainbow = 0;
    private Player[] viewers;

    public CustomAnimation(Particle particle, MovableMid mid, double radius, double height, int speed) {
        super(particle);
        this.mid = mid;
        this.radius = radius;
        this.height = height;
        this.setSpeed(speed);
        this.zero = mid.getLocation();
        this.zero.setX(0.0);
        this.zero.setY(0.0);
        this.zero.setZ(0.0);
    }

    public CustomAnimation(Particle particle, Location mid, double radius, double height, int speed) {
        super(particle);
        this.mid = new LocationMid(mid);
        this.radius = radius;
        this.height = height;
        this.setSpeed(speed);
        this.zero = mid.clone();
        this.zero.setX(0.0);
        this.zero.setY(0.0);
        this.zero.setZ(0.0);
    }

    private void cache() {
        if (!this.useOwnCache()) {
            return;
        }
        if (!this.CACHE.isEmpty()) {
            this.CACHE.clear();
        }
        List<List<Location>> calculated = this.calculate(false);
        this.CACHE.addAll(calculated);
        calculated.clear();
    }

    private boolean useOwnCache() {
        return this.radius > 3.0;
    }

    private void rotate(Location l) {
        if (this.calculateSinCos) {
            double rX = (double)this.xRotation * Math.PI / 180.0;
            double rY = (double)this.yRotation * Math.PI / 180.0;
            double rZ = (double)this.zRotation * Math.PI / 180.0;
            this.sinX = Math.sin(rX);
            this.sinY = Math.sin(rY);
            this.sinZ = Math.sin(rZ);
            this.cosX = Math.cos(rX);
            this.cosY = Math.cos(rY);
            this.cosZ = Math.cos(rZ);
            this.calculateSinCos = false;
        }
        double y = l.getY();
        double z = l.getZ();
        l.setY(y * this.cosX - z * this.sinX);
        l.setZ(z * this.cosX + y * this.sinX);
        double x = l.getX();
        y = l.getY();
        l.setX(x * this.cosZ - y * this.sinZ);
        l.setY(y * this.cosZ + x * this.sinZ);
        x = l.getX();
        z = l.getZ();
        l.setX(x * this.cosY - z * this.sinY);
        l.setZ(z * this.cosY + x * this.sinY);
    }

    private void adjustLocations(List<Location> locations) {
        boolean rotation = this.xRotation != 0 || this.yRotation != 0 || this.zRotation != 0;
        Location mid = this.mid.getLocation();
        if (mid == null) {
            this.setRunning(false);
            return;
        }
        for (Location location : locations) {
            if (rotation) {
                this.rotate(location);
            }
            if (!this.useOwnCache()) {
                location.multiply(this.getRadius() / 2.0);
            }
            location.add(mid.getX(), mid.getY() + this.getHeight(), mid.getZ());
            location.setWorld(mid.getWorld());
        }
    }

    @Override
    public void onTick() {
        List<Location> locations;
        List<Location> list;
        if (this.delay > 0) {
            if (this.skipped < this.delay) {
                ++this.skipped;
                this.mid.onTick();
                return;
            }
            if (this.skipped == this.delay) {
                this.skipped = 0;
            }
        }
        this.mid.onTick();
        if (!this.mid.isStanding()) {
            return;
        }
        if (this.getCache().size() <= this.playId) {
            list = null;
        } else {
            int n;
            if (this.isMotionAnimation()) {
                int n2 = this.playId;
                n = n2;
                this.playId = n2 + 1;
            } else {
                n = 0;
            }
            list = locations = this.get(n);
        }
        if (locations == null) {
            this.playId = 0;
            locations = this.get(this.playId++);
        }
        if (locations == null) {
            this.setRunning(false);
            throw new NullPointerException("No particle locations available!");
        }
        locations = this.copy(locations);
        this.adjustLocations(locations);
        if (locations != null) {
            if (this.viewers == null) {
                for (Location location : locations) {
                    this.getParticle().send(location, this.buildColor(), this.buildNoteColor(), true, this.getMaxDistance());
                    if (this.color != de.codingair.tradesystem.lib.codingapi.particles.utils.Color.RAINBOW) continue;
                    ++this.rainbow;
                    if (this.rainbow < this.getMaxRainbowValue()) continue;
                    this.rainbow = 0;
                }
            } else {
                for (Location location : locations) {
                    this.getParticle().send(location, this.buildColor(), this.buildNoteColor(), true, this.getMaxDistance(), this.viewers);
                    if (this.color != de.codingair.tradesystem.lib.codingapi.particles.utils.Color.RAINBOW) continue;
                    ++this.rainbow;
                    if (this.rainbow < this.getMaxRainbowValue()) continue;
                    this.rainbow = 0;
                }
            }
            locations.clear();
        }
    }

    private int getMaxRainbowValue() {
        return this.getParticle() == Particle.NOTE ? de.codingair.tradesystem.lib.codingapi.particles.utils.Color.RAINBOW_NOTE_COLOR_LENGTH : de.codingair.tradesystem.lib.codingapi.particles.utils.Color.RAINBOW_COLOR_LENGTH;
    }

    private int buildNoteColor() {
        int noteColor = this.color == null ? 0 : (this.color == de.codingair.tradesystem.lib.codingapi.particles.utils.Color.RAINBOW ? this.rainbow : this.color.getNoteColor());
        return noteColor;
    }

    @Nullable
    private Color buildColor() {
        Color color = this.color == null ? null : (this.getParticle() == Particle.NOTE ? de.codingair.tradesystem.lib.codingapi.particles.utils.Color.RED.getColor() : (this.color == de.codingair.tradesystem.lib.codingapi.particles.utils.Color.RAINBOW ? de.codingair.tradesystem.lib.codingapi.particles.utils.Color.values()[this.rainbow].getColor() : this.color.getColor()));
        return color;
    }

    @Override
    public void setRunning(boolean running) {
        if (this.isRunning() == running) {
            return;
        }
        if (!running) {
            this.CACHE.clear();
        } else {
            this.cache();
        }
        super.setRunning(running);
    }

    public abstract List<List<Location>> calculate(boolean var1);

    public abstract boolean isMotionAnimation();

    private List<Location> get(int playId) {
        return this.getCache().size() <= playId ? null : this.getCache().get(playId);
    }

    abstract List<List<Location>> getAnimCache();

    private List<List<Location>> getCache() {
        if (this.useOwnCache()) {
            return this.CACHE;
        }
        if (this.getAnimCache().isEmpty()) {
            this.calculate(true);
        }
        return this.getAnimCache();
    }

    public HitBox getHitBox() {
        List<List<Location>> cache = this.getCache();
        HitBox box = null;
        for (List<Location> locations : cache) {
            List<Location> copy = this.copy(locations);
            this.adjustLocations(copy);
            for (Location l : copy) {
                if (box == null) {
                    box = new HitBox(l.getX(), l.getY(), l.getZ());
                    continue;
                }
                box.addProperty(l.getX(), l.getY(), l.getZ());
            }
            copy.clear();
        }
        return box;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getHeight() {
        return this.height;
    }

    public int getXRotation() {
        return this.xRotation;
    }

    public CustomAnimation setXRotation(int xRotation) {
        this.xRotation = xRotation;
        this.calculateSinCos = true;
        return this;
    }

    public int getYRotation() {
        return this.yRotation;
    }

    public CustomAnimation setYRotation(int yRotation) {
        this.yRotation = yRotation;
        this.calculateSinCos = true;
        return this;
    }

    public int getZRotation() {
        return this.zRotation;
    }

    public CustomAnimation setZRotation(int zRotation) {
        this.zRotation = zRotation;
        this.calculateSinCos = true;
        return this;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        if (speed < 1) {
            speed = 1;
        }
        if (speed > 10) {
            speed = 10;
        }
        this.delay = 10 - speed;
        this.speed = speed;
    }

    public de.codingair.tradesystem.lib.codingapi.particles.utils.Color getColor() {
        return this.color;
    }

    public <C extends CustomAnimation> C setColor(de.codingair.tradesystem.lib.codingapi.particles.utils.Color color) {
        this.color = color;
        return (C)this;
    }

    public Player[] getViewers() {
        return this.viewers;
    }

    public CustomAnimation setViewers(Player[] viewers) {
        this.viewers = viewers;
        return this;
    }

    public Location getZero() {
        return this.zero.clone();
    }

    public List<Location> copy(List<Location> cache) {
        ArrayList<Location> copy = new ArrayList<Location>();
        for (Location l : cache) {
            copy.add(l.clone());
        }
        return copy;
    }

    public void clear(List<List<Location>> cache) {
        if (cache == null) {
            return;
        }
        for (List<Location> locations : cache) {
            locations.clear();
        }
        cache.clear();
    }
}

