/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations;

import de.codingair.tradesystem.lib.codingapi.particles.Particle;
import de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations.CustomAnimation;
import de.codingair.tradesystem.lib.codingapi.particles.animations.movables.MovableMid;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;

public class CircleAnimation
extends CustomAnimation {
    private static final List<List<Location>> CACHE = new ArrayList<List<Location>>();

    public CircleAnimation(Particle particle, MovableMid mid, double radius, double height, int delay) {
        super(particle, mid, radius, height, delay);
    }

    public CircleAnimation(Particle particle, Location mid, double radius, double height, int delay) {
        super(particle, mid, radius, height, delay);
    }

    @Override
    public List<List<Location>> calculate(boolean cached) {
        double r = cached ? 2.0 : this.getRadius();
        ArrayList<List<Location>> locations = cached ? CACHE : new ArrayList<List<Location>>();
        this.clear(CACHE);
        double t = 0.0;
        while (t < Math.PI * 2) {
            ArrayList<Location> l = new ArrayList<Location>();
            double x = r * Math.cos(t += 0.39269908169872414);
            double z = r * Math.sin(t);
            l.add(this.getZero().add(x, 0.0, z));
            locations.add(l);
        }
        return locations;
    }

    @Override
    public boolean isMotionAnimation() {
        return true;
    }

    @Override
    List<List<Location>> getAnimCache() {
        return CACHE;
    }
}

