/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations;

import de.codingair.tradesystem.lib.codingapi.particles.Particle;
import de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations.CircleAnimation;
import de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations.CustomAnimation;
import de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations.LineAnimation;
import de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations.PulsingCircleAnimation;
import de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations.RotatingCircleAnimation;
import de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations.SinusAnimation;
import de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations.VectorAnimation;
import de.codingair.tradesystem.lib.codingapi.particles.animations.movables.MovableMid;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.bukkit.entity.Player;

public enum AnimationType {
    CIRCLE(0, CircleAnimation.class, "Circle"),
    PULSING_CIRCLE(1, PulsingCircleAnimation.class, "Pulsing Circle"),
    ROTATING_CIRCLE(2, RotatingCircleAnimation.class, "Rotating Circle"),
    SINUS(3, SinusAnimation.class, "Sinus"),
    VECTOR(4, VectorAnimation.class, "Vector"),
    LINE(5, LineAnimation.class, "Line");

    private final int id;
    private final Class<? extends CustomAnimation> clazz;
    private final String displayName;

    private AnimationType(int id, Class<? extends CustomAnimation> clazz, String displayName) {
        this.id = id;
        this.clazz = clazz;
        this.displayName = displayName;
    }

    public CustomAnimation build(Particle particle, Player[] players, MovableMid mid, double radius, double height, int speed) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.clazz.getConstructor(Particle.class, MovableMid.class, Double.TYPE, Double.TYPE, Integer.TYPE).newInstance(new Object[]{particle, mid, radius, height, speed}).setViewers(players);
    }

    public int getId() {
        return this.id;
    }

    public Class<? extends CustomAnimation> getClazz() {
        return this.clazz;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public AnimationType next() {
        return AnimationType.next(this.id);
    }

    public AnimationType previous() {
        return AnimationType.previous(this.id);
    }

    public String toString() {
        return this.displayName;
    }

    public static AnimationType getById(int id) {
        for (AnimationType value : AnimationType.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        throw new IllegalArgumentException("Couldn't found AnimationType with id=" + id);
    }

    public static AnimationType next(int id) {
        for (int i = 0; i < AnimationType.values().length; ++i) {
            if (AnimationType.values()[i].getId() != id) continue;
            return i + 1 == AnimationType.values().length ? AnimationType.values()[0] : AnimationType.values()[i + 1];
        }
        throw new IllegalArgumentException("Couldn't found AnimationType with id=" + id);
    }

    public static AnimationType previous(int id) {
        for (int i = 0; i < AnimationType.values().length; ++i) {
            if (AnimationType.values()[i].getId() != id) continue;
            return i - 1 < 0 ? AnimationType.values()[AnimationType.values().length - 1] : AnimationType.values()[i - 1];
        }
        throw new IllegalArgumentException("Couldn't found AnimationType with id=" + id);
    }

    public static void clearCache() {
        for (AnimationType value : AnimationType.values()) {
            IReflection.FieldAccessor cache = IReflection.getField(value.getClazz(), "CACHE");
            List CACHE = (List)cache.get(null);
            for (List l : CACHE) {
                l.clear();
            }
            CACHE.clear();
        }
    }
}

