/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.particles.animations;

import de.codingair.tradesystem.lib.codingapi.API;
import de.codingair.tradesystem.lib.codingapi.particles.Particle;
import de.codingair.tradesystem.lib.codingapi.utils.Ticker;
import org.bukkit.Location;

public abstract class Animation
implements Ticker {
    private final Particle particle;
    private double maxDistance = 30.0;

    public Animation(Particle particle) {
        this.particle = particle;
    }

    public boolean isRunning() {
        return API.isRunning(this);
    }

    public void setRunning(boolean running) {
        if (running && !this.isRunning()) {
            API.addTicker(this);
        } else if (!running && this.isRunning()) {
            API.removeTicker(this);
        }
    }

    public final void sendParticle(Location location) {
        this.getParticle().send(location, this.maxDistance);
    }

    public Particle getParticle() {
        return this.particle;
    }

    @Override
    public void onSecond() {
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
    }
}

