/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.particles;

import de.codingair.tradesystem.lib.codingapi.particles.Particle;
import de.codingair.tradesystem.lib.codingapi.particles.ParticleData;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.server.reflections.PacketUtils;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import java.awt.Color;
import java.lang.reflect.Constructor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class ParticlePacket {
    private static final Class<?> packetPlayOutWorldParticles;
    private static final Class<?> particleParam;
    private static final Class<?> craftParticle;
    private static final Class<?> dustOptions;
    private static final IReflection.MethodAccessor toNMS;
    private final Particle particle;
    private Object packet;
    private Color color = null;
    private boolean longDistance = false;
    private Location location;
    private double maxDistance = 0.0;
    private int noteId = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ParticlePacket(Particle particle) {
        this.particle = particle;
    }

    public ParticlePacket(Particle particle, Color color, boolean longDistance) {
        this.particle = particle;
        this.color = color;
        this.longDistance = longDistance;
    }

    public ParticlePacket initialize(Location loc) {
        if (!this.available()) {
            return this;
        }
        this.location = loc;
        Class<?> packetClass = IReflection.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutWorldParticles");
        Constructor<?> packetConstructor = IReflection.getConstructor(packetClass, new Class[0]).getConstructor();
        if (Version.get().isBiggerThan(Version.v1_12)) {
            Object particle;
            Object data = null;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            float extra = 0.0f;
            int count = 1;
            if (this.color != null) {
                if (this.particle == Particle.REDSTONE) {
                    data = IReflection.getConstructor(dustOptions, org.bukkit.Color.class, Float.TYPE).newInstance(org.bukkit.Color.fromRGB((int)this.color.getRed(), (int)this.color.getGreen(), (int)this.color.getBlue()), 1);
                } else if (this.particle == Particle.NOTE) {
                    count = 0;
                    offsetX = (float)this.noteId / 24.0f;
                    extra = 1.0f;
                } else if (this.particle == Particle.SPELL_MOB || this.particle == Particle.SPELL_MOB_AMBIENT) {
                    count = 0;
                    offsetX = (float)this.color.getRed() / 255.0f;
                    offsetY = (float)this.color.getGreen() / 255.0f;
                    offsetZ = (float)this.color.getBlue() / 255.0f;
                    extra = 1.0f;
                }
            }
            try {
                particle = toNMS.invoke(null, org.bukkit.Particle.valueOf((String)this.particle.name()), data);
            }
            catch (Exception ex) {
                return this;
            }
            if (Version.atLeast(17.0)) {
                IReflection.ConstructorAccessor packetCon = IReflection.getConstructor(packetPlayOutWorldParticles, particleParam, Boolean.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE);
                if (!$assertionsDisabled && packetCon == null) {
                    throw new AssertionError();
                }
                this.packet = packetCon.newInstance(particle, this.longDistance, this.location.getX(), this.location.getY(), this.location.getZ(), Float.valueOf(offsetX), Float.valueOf(offsetY), Float.valueOf(offsetZ), Float.valueOf(extra), count);
            } else {
                IReflection.ConstructorAccessor packetCon = IReflection.getConstructor(packetPlayOutWorldParticles, new Class[0]);
                if (!$assertionsDisabled && packetCon == null) {
                    throw new AssertionError();
                }
                this.packet = packetCon.newInstance(new Object[0]);
                try {
                    IReflection.setValue(this.packet, "a", Float.valueOf((float)this.location.getX()));
                    IReflection.setValue(this.packet, "b", Float.valueOf((float)this.location.getY()));
                    IReflection.setValue(this.packet, "c", Float.valueOf((float)this.location.getZ()));
                    IReflection.setValue(this.packet, "d", Float.valueOf(offsetX));
                    IReflection.setValue(this.packet, "e", Float.valueOf(offsetY));
                    IReflection.setValue(this.packet, "f", Float.valueOf(offsetZ));
                    IReflection.setValue(this.packet, "g", Float.valueOf(extra));
                    IReflection.setValue(this.packet, "h", count);
                    IReflection.setValue(this.packet, "i", this.longDistance);
                    IReflection.setValue(this.packet, "j", particle);
                }
                catch (IllegalAccessException | NoSuchFieldException e1) {
                    e1.printStackTrace();
                }
            }
        } else {
            Class<?> enumParticle = IReflection.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE, "EnumParticle");
            ParticleData data = null;
            if (this.particle.requiresData()) {
                Location below = loc.clone();
                below.setY((double)loc.getBlockY() - 0.49);
                data = new ParticleData(below.getBlock().getType(), below.getBlock().getData());
            }
            if (this.particle.requiresWater() && !loc.getBlock().getType().equals((Object)Material.WATER) && !loc.getBlock().getType().equals((Object)Material.valueOf((String)"STATIONARY_WATER"))) {
                return this;
            }
            float e = 0.0f;
            float f = 0.0f;
            float g = 0.0f;
            float h = 0.0f;
            int i = 1;
            if (this.particle.isColorable() && this.color != null) {
                e = (float)this.color.getRed() / 255.0f;
                if (e == 0.0f) {
                    e = 0.003921569f;
                }
                f = (float)this.color.getGreen() / 255.0f;
                g = (float)this.color.getBlue() / 255.0f;
                h = 1.0f;
                i = 0;
            }
            try {
                this.packet = packetConstructor.newInstance(new Object[0]);
                IReflection.setValue(this.packet, "a", enumParticle.getEnumConstants()[this.particle.getId()]);
                IReflection.setValue(this.packet, "j", this.longDistance);
                if (data != null) {
                    int[] nArray;
                    int[] packetData = data.getPacketData();
                    if (this.particle == Particle.ITEM_CRACK) {
                        nArray = packetData;
                    } else {
                        int[] nArray2 = new int[1];
                        nArray = nArray2;
                        nArray2[0] = packetData[0] | packetData[1] << 12;
                    }
                    IReflection.setValue(this.packet, "k", nArray);
                }
                IReflection.setValue(this.packet, "b", Float.valueOf((float)this.location.getX()));
                IReflection.setValue(this.packet, "c", Float.valueOf((float)this.location.getY()));
                IReflection.setValue(this.packet, "d", Float.valueOf((float)this.location.getZ()));
                IReflection.setValue(this.packet, "e", Float.valueOf(e));
                IReflection.setValue(this.packet, "f", Float.valueOf(f));
                IReflection.setValue(this.packet, "g", Float.valueOf(g));
                IReflection.setValue(this.packet, "h", Float.valueOf(h));
                IReflection.setValue(this.packet, "i", i);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this;
    }

    public boolean available() {
        if (Version.get().isBiggerThan(Version.v1_12)) {
            return this.particle != null && this.particle.getName_v1_13() != null;
        }
        Class<?> enumParticle = IReflection.getClass(IReflection.ServerPacket.MINECRAFT_PACKAGE, "EnumParticle");
        return enumParticle.getEnumConstants().length - 1 >= this.particle.getId();
    }

    public void send(Player ... p) {
        if (this.packet == null || this.location == null) {
            return;
        }
        for (Player player : p) {
            if (player.getWorld() != this.location.getWorld() || !(this.maxDistance <= 0.0) && !(this.location.distance(player.getLocation()) <= this.maxDistance)) continue;
            PacketUtils.sendPacket(this.packet, player);
        }
    }

    public void send() {
        if (this.packet == null || this.location == null) {
            return;
        }
        this.send(Bukkit.getOnlinePlayers().toArray(new Player[0]));
    }

    public Particle getParticle() {
        return this.particle;
    }

    public Object getPacket() {
        return this.packet;
    }

    public Color getColor() {
        return this.color;
    }

    public ParticlePacket setColor(Color color) {
        this.color = color;
        return this;
    }

    public ParticlePacket clone() {
        ParticlePacket packet = new ParticlePacket(this.particle);
        packet.setColor(this.color);
        packet.setLongDistance(this.longDistance);
        return packet;
    }

    public boolean isLongDistance() {
        return this.longDistance;
    }

    public void setLongDistance(boolean longDistance) {
        this.longDistance = longDistance;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    public int getNoteId() {
        return this.noteId;
    }

    public void setNoteId(int noteId) {
        this.noteId = noteId;
    }

    static {
        boolean bl = $assertionsDisabled = !ParticlePacket.class.desiredAssertionStatus();
        if (Version.get().isBiggerThan(Version.v1_12)) {
            packetPlayOutWorldParticles = IReflection.getClass(IReflection.ServerPacket.PACKETS, "PacketPlayOutWorldParticles");
            particleParam = IReflection.getClass(IReflection.ServerPacket.PARTICLES, "ParticleParam");
            craftParticle = IReflection.getClass(IReflection.ServerPacket.CRAFTBUKKIT_PACKAGE, "CraftParticle");
            dustOptions = IReflection.getClass(IReflection.ServerPacket.BUKKIT_PACKET, "Particle$DustOptions");
            toNMS = IReflection.getMethod(craftParticle, particleParam, new Class[]{org.bukkit.Particle.class, Object.class});
        } else {
            packetPlayOutWorldParticles = null;
            particleParam = null;
            craftParticle = null;
            dustOptions = null;
            toNMS = null;
        }
    }
}

