/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.nms;

import de.codingair.tradesystem.lib.codingapi.nms.NmsCheckError;
import de.codingair.tradesystem.lib.codingapi.nms.NmsLoader;
import de.codingair.tradesystem.lib.codingapi.player.Hologram;
import de.codingair.tradesystem.lib.codingapi.player.data.PacketReader;
import de.codingair.tradesystem.lib.codingapi.player.gui.anvil.AnvilGUI;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.InventoryUtils;
import de.codingair.tradesystem.lib.codingapi.player.gui.inventory.PlayerInventory;
import de.codingair.tradesystem.lib.codingapi.player.gui.sign.SignGUI;
import de.codingair.tradesystem.lib.codingapi.server.listeners.PickItemListener;
import de.codingair.tradesystem.lib.codingapi.server.reflections.PacketUtils;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.codingapi.tools.nbt.NBTTagCompound;
import de.codingair.tradesystem.lib.codingapi.tools.nbt.specific.BlockEntityNBTTagCompound;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Bukkit;

public class NmsCheck {
    private static final Class<?>[] C;
    private static boolean internalApiTested;

    private NmsCheck() {
    }

    public static void testInternalApi() {
        internalApiTested = true;
        NmsCheck.testVersion();
        NmsCheck.test(C);
    }

    public static void test(@NotNull @NotNull Class<?> @NotNull [] classes) {
        if (!internalApiTested) {
            NmsCheck.testInternalApi();
        }
        for (Class<?> c : classes) {
            NmsCheck.test(c);
        }
    }

    private static void test(Class<?> c) {
        try {
            NmsCheck.runNmsLoader(c);
        }
        catch (Throwable t) {
            throw new NmsCheckError("Could not initialize class: " + c.getName() + ". Version=" + (Object)((Object)Version.get()) + ", Type=" + (Object)((Object)Version.type()) + ", Bukkit='" + Bukkit.getVersion() + "'", t);
        }
    }

    private static void testVersion() {
        try {
            if (Version.get() == null) {
                throw new NmsCheckError("Could not initialize version reader. Bukkit='" + Bukkit.getVersion() + "'");
            }
        }
        catch (Throwable t) {
            throw new NmsCheckError("Could not initialize version reader. Bukkit='" + Bukkit.getVersion() + "'", t);
        }
    }

    private static void runNmsLoader(Class<?> c) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Object obj = null;
        for (Constructor<?> con : c.getDeclaredConstructors()) {
            if (con.getParameterCount() != 0 || !con.isAnnotationPresent(NmsLoader.class)) continue;
            con.setAccessible(true);
            obj = con.newInstance(new Object[0]);
            break;
        }
        if (obj == null) {
            if (c.getSuperclass() != Object.class) {
                try {
                    NmsCheck.runNmsLoader(c.getSuperclass());
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            throw new IllegalStateException(c.getSimpleName() + " is missing an empty constructor!");
        }
    }

    static {
        internalApiTested = false;
        C = new Class[]{PacketUtils.class, AnvilGUI.class, SignGUI.NmsWrapper.class, InventoryUtils.class, PickItemListener.class, NBTTagCompound.class, BlockEntityNBTTagCompound.class, Hologram.HologramPackets.class, Hologram.class, PacketReader.NmsWrapper.class, PlayerInventory.class};
    }
}

