/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.files.loader;

import com.google.common.base.Charsets;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.Files;
import de.codingair.tradesystem.lib.codingapi.files.loader.Extra;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import de.codingair.tradesystem.lib.jetbrains.annotations.NotNull;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class UTFConfig
extends YamlConfiguration {
    private static final String COMMENT = "# ";
    private final List<Extra> extras = new ArrayList<Extra>();
    private final Cache<String, String> caseSensitive = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private boolean deployedExtras = false;

    private UTFConfig() {
    }

    public UTFConfig copy() {
        UTFConfig config = new UTFConfig();
        config.map.putAll(this.map);
        return config;
    }

    public static UTFConfig loadConf(File file) {
        UTFConfig loader = new UTFConfig();
        try {
            loader.load(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loader;
    }

    public static UTFConfig loadConf(InputStream stream) {
        UTFConfig loader = new UTFConfig();
        try {
            loader.load(new InputStreamReader(stream, Charsets.UTF_8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loader;
    }

    public void destroy() {
        this.extras.clear();
    }

    public Object get(@NotNull String path, Object def) {
        Object value = super.get(path, null);
        if (value == null) {
            String key = (String)this.caseSensitive.getIfPresent((Object)(path = path.toLowerCase()));
            if (key == null) {
                for (String s : this.getKeys(true)) {
                    if (!s.toLowerCase().equals(path)) continue;
                    key = s;
                    this.caseSensitive.put((Object)path, (Object)s);
                    break;
                }
            }
            if (key != null) {
                value = super.get(key, def);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@NotNull File file) throws IOException {
        Files.createParentDirs((File)file);
        String data = Version.atLeast(18.1) ? this.saveToString() : this.writeExtras(this.saveToString());
        StringBuilder builder = new StringBuilder();
        try (BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));){
            String line;
            while ((line = input.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
        }
        String old = builder.toString();
        if (data.equals(old)) {
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);){
            writer.write(data);
        }
    }

    @NotNull
    protected String parseHeader(@NotNull String input) {
        return "";
    }

    @NotNull
    protected String buildHeader() {
        return "";
    }

    public void loadFromString(@NotNull String contents) throws InvalidConfigurationException {
        super.loadFromString(contents);
        if (Version.before(18.1)) {
            this.loadExtras(contents);
        }
    }

    public void removeUnused(UTFConfig origin) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : this.getKeys(true)) {
            if (!origin.contains(key)) {
                toRemove.add(key);
                continue;
            }
            Object current = this.get(key);
            Object old = origin.get(key);
            if (!(old instanceof Map) && current instanceof Map) {
                toRemove.add(key);
            } else if (!(current instanceof Map) && old instanceof Map) {
                toRemove.add(key);
            }
            if (!(old instanceof ConfigurationSection) && current instanceof ConfigurationSection) {
                toRemove.add(key);
                continue;
            }
            if (current instanceof ConfigurationSection || !(old instanceof ConfigurationSection)) continue;
            toRemove.add(key);
        }
        for (String key : toRemove) {
            this.set(key, null);
        }
    }

    public void deployExtras(String contents) {
        this.loadExtras(contents);
        this.deployedExtras = true;
    }

    private void loadExtras(String contents) {
        if (this.deployedExtras) {
            return;
        }
        this.extras.clear();
        int line = 0;
        String[] a = contents.split("\n", -1);
        int list = -1;
        for (int i = 0; i < a.length - 1; ++i) {
            String s = a[i];
            int empty = 0;
            while (s.startsWith(" ")) {
                s = s.substring(1);
                ++empty;
            }
            if (list > -1) {
                int n = list = list < empty ? list : -1;
                if (list > -1) continue;
            }
            if (s.startsWith("-")) {
                list = empty;
                continue;
            }
            if (this.isComment(a[i]) || this.isEmpty(a[i])) {
                this.extras.add(new Extra(a[i], line));
            }
            ++line;
        }
    }

    private boolean isComment(String s) {
        while (s.startsWith(" ")) {
            s = s.replaceFirst(" ", "");
        }
        return s.startsWith(COMMENT);
    }

    private boolean isEmpty(String s) {
        while (s.startsWith(" ")) {
            s = s.replaceFirst(" ", "");
        }
        return s.isEmpty() || s.equals("\n");
    }

    private String writeExtras(String contents) {
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(contents.split("\n", -1)));
        int size = lines.size() + this.extras.size();
        int e = 0;
        int listItems = 0;
        int list = -1;
        for (int i = 0; i < size && this.extras.size() != e; ++i) {
            if (lines.size() == i) {
                lines.add(this.extras.get(e++).getText());
                continue;
            }
            String s = (String)lines.get(i);
            int empty = 0;
            while (s.startsWith(" ")) {
                s = s.substring(1);
                ++empty;
            }
            if (list > -1) {
                int n = list = list < empty ? list : -1;
                if (list > -1) {
                    ++listItems;
                    continue;
                }
            }
            if (s.startsWith("-")) {
                ++listItems;
                list = empty;
                continue;
            }
            if (this.extras.get(e).getLine() != i - listItems) continue;
            lines.add(i, this.extras.get(e++).getText());
        }
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < lines.size(); ++j) {
            builder.append((String)lines.get(j));
            if (j >= lines.size() - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    public void setDefaults(InputStream stream) {
        super.setDefaults((Configuration)UTFConfig.loadConf(stream));
    }
}

