/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.files;

import com.google.common.base.Preconditions;
import de.codingair.tradesystem.lib.codingapi.files.ConfigFile;
import java.util.HashMap;
import org.bukkit.plugin.java.JavaPlugin;

public class FileManager {
    private final JavaPlugin plugin;
    private final HashMap<String, ConfigFile> cache = new HashMap();

    public FileManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    private String key(ConfigFile file) {
        return this.key(file.getName());
    }

    private String key(String name) {
        Preconditions.checkNotNull((Object)name);
        return name.toLowerCase().trim();
    }

    public ConfigFile getFile(String name) {
        return this.cache.get(this.key(name));
    }

    public void unloadFile(ConfigFile file) {
        this.cache.remove(this.key(file));
        file.destroy();
    }

    public ConfigFile loadFile(String name) {
        return this.loadFile(name, "/", true);
    }

    public ConfigFile loadFile(String name, String path) {
        return this.loadFile(name, path, true);
    }

    public ConfigFile loadFile(String name, String path, boolean removeUnused) {
        return this.loadFile(name, path, null, removeUnused);
    }

    public ConfigFile loadFile(String name, String path, boolean removeUnused, boolean raw) {
        return this.loadFile(name, path, null, removeUnused, raw);
    }

    public ConfigFile loadFile(String name, String path, String srcPath) {
        return this.loadFile(name, path, srcPath, true);
    }

    public ConfigFile loadFile(String name, String path, String srcPath, boolean removeUnused) {
        return this.loadFile(name, path, srcPath, removeUnused, false);
    }

    public ConfigFile loadFile(String name, String path, String srcPath, boolean removeUnused, boolean raw) {
        ConfigFile c = this.getFile(name);
        if (c != null) {
            return c;
        }
        c = new ConfigFile(this.plugin, name, path, srcPath, removeUnused, raw);
        this.cache.put(this.key(c), c);
        return c;
    }

    public void destroy() {
        this.cache.values().forEach(ConfigFile::destroy);
        this.cache.clear();
    }
}

