/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.files;

import com.google.common.base.Charsets;
import de.codingair.tradesystem.lib.codingapi.files.loader.UTFConfig;
import de.codingair.tradesystem.lib.codingapi.server.specification.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigFile {
    private YamlConfiguration config = null;
    private File configFile = null;
    private final JavaPlugin plugin;
    private final String name;
    private String path;
    private String srcPath;
    private final boolean raw;

    public ConfigFile(JavaPlugin plugin, String name, String path) {
        this(plugin, name, path, true);
    }

    public ConfigFile(JavaPlugin plugin, String name, String path, boolean removeUnused) {
        this(plugin, name, path, null, removeUnused);
    }

    public ConfigFile(JavaPlugin plugin, String name, String path, String srcPath) {
        this(plugin, name, path, srcPath, true);
    }

    public ConfigFile(JavaPlugin plugin, String name, String path, String srcPath, boolean removeUnused) {
        this(plugin, name, path, srcPath, removeUnused, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigFile(JavaPlugin plugin, String name, String path, String srcPath, boolean removeUnused, boolean raw) {
        this.plugin = plugin;
        this.name = name;
        this.path = path;
        this.srcPath = srcPath;
        this.raw = raw;
        if (this.srcPath != null) {
            if (this.srcPath.startsWith("/")) {
                this.srcPath = this.srcPath.replaceFirst("/", "");
            }
            if (!this.srcPath.endsWith("/")) {
                this.srcPath = this.srcPath + "/";
            }
        }
        this.loadConfig();
        InputStream in = plugin.getResource((this.srcPath == null ? "" : this.srcPath) + this.name + ".yml");
        if (in != null) {
            InputStreamReader reader = new InputStreamReader(in, Charsets.UTF_8);
            BufferedReader input = new BufferedReader(reader);
            StringBuilder builder = new StringBuilder();
            try {
                try {
                    String line;
                    while ((line = input.readLine()) != null) {
                        builder.append(line);
                        builder.append('\n');
                    }
                }
                finally {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            String read = builder.toString().startsWith("~Config\n") ? builder.toString().replaceFirst("~Config\n", "") : builder.toString();
            if (this.config instanceof UTFConfig) {
                ((UTFConfig)this.config).deployExtras(read);
            }
            if (removeUnused && (in = plugin.getResource((this.srcPath == null ? "" : this.srcPath) + this.name + ".yml")) != null && this.config instanceof UTFConfig) {
                ((UTFConfig)this.config).removeUnused(UTFConfig.loadConf(in));
            }
            this.config.options().copyDefaults(true);
            this.config.options().copyHeader(true);
            this.saveConfig();
        }
    }

    private void mkDir(File file) {
        if (!file.getParentFile().exists()) {
            this.mkDir(file.getParentFile());
        }
        if (!file.exists()) {
            try {
                file.mkdir();
            }
            catch (SecurityException ex) {
                throw new IllegalArgumentException("Plugin is not permitted to create a folder!");
            }
        }
    }

    public void loadConfig() {
        try {
            InputStream reader;
            File folder = this.plugin.getDataFolder();
            if (!folder.exists()) {
                this.mkDir(folder);
            }
            if (!this.path.startsWith("/")) {
                this.path = "/" + this.path;
            }
            if (!this.path.endsWith("/")) {
                this.path = this.path + "/";
            }
            folder = new File(this.plugin.getDataFolder() + this.path);
            if (!(this.path.isEmpty() || this.path.equals("/") || folder.exists())) {
                this.mkDir(folder);
            }
            this.configFile = new File(this.plugin.getDataFolder() + this.path, this.name + ".yml");
            if (!this.configFile.exists()) {
                this.configFile.createNewFile();
                try (InputStream in = this.plugin.getResource((this.srcPath == null ? "" : this.srcPath) + this.name + ".yml");
                     FileOutputStream out = new FileOutputStream(this.configFile);){
                    this.copy(in, out);
                }
            }
            InputStream inputStream = this.raw ? null : (reader = this.plugin.getResource((this.srcPath == null ? "" : this.srcPath) + this.name + ".yml"));
            if (reader != null) {
                this.config = Version.atLeast(19.3) ? YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(reader, Charsets.UTF_8)) : UTFConfig.loadConf(reader);
                this.mergeConfigFile();
            } else {
                this.config = UTFConfig.loadConf(this.configFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void mergeConfigFile() {
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)this.configFile);
        for (String key : this.config.getKeys(true)) {
            Object current = this.config.get(key);
            Object fileValue = c.get(key);
            if (current == null || fileValue == null || current.getClass() != fileValue.getClass() || current instanceof ConfigurationSection) continue;
            this.config.set(key, fileValue);
        }
    }

    private long copy(InputStream from, OutputStream to) throws IOException {
        if (from == null) {
            return -1L;
        }
        if (to == null) {
            throw new NullPointerException();
        }
        byte[] buf = new byte[4096];
        long total = 0L;
        int r;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public void reloadConfig() {
        this.saveConfig();
        this.loadConfig();
    }

    public YamlConfiguration getConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    public void saveConfig() {
        this.saveConfig(false);
    }

    public void destroy() {
        if (this.config instanceof UTFConfig) {
            ((UTFConfig)this.config).destroy();
        }
    }

    public void saveConfig(boolean destroy) {
        if (this.config == null || this.configFile == null) {
            return;
        }
        try {
            this.getConfig().save(this.configFile);
            if (destroy) {
                this.destroy();
            }
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + this.configFile, ex);
        }
    }

    public void clearConfig() {
        if (this.config == null) {
            return;
        }
        for (String key : this.config.getKeys(false)) {
            this.config.set(key, null);
        }
    }

    public void delete() {
        if (this.configFile == null) {
            return;
        }
        if (!this.configFile.delete()) {
            this.configFile.deleteOnExit();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }
}

