/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.bungeecord.files.loader;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import de.codingair.tradesystem.lib.codingapi.files.loader.Extra;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

public class UTFConfiguration
extends ConfigurationProvider {
    private static final String COMMENT = "#";
    private final List<Extra> extras = new ArrayList<Extra>();
    private boolean deployedExtras = false;
    private Configuration config;
    private final ThreadLocal<Yaml> yaml = new ThreadLocal<Yaml>(){

        @Override
        protected Yaml initialValue() {
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Representer representer = new Representer(options){
                {
                    this.representers.put(Configuration.class, data -> this.represent(UTFConfiguration.this.getSelf((Configuration)data)));
                }
            };
            return new Yaml((BaseConstructor)new Constructor(new LoaderOptions()), representer, options);
        }
    };

    public void destroy() {
        this.extras.clear();
    }

    private Map<String, Object> getSelf(Configuration config) {
        IReflection.FieldAccessor self = IReflection.getField(Configuration.class, "self");
        return (Map)self.get(config);
    }

    private Configuration createConfiguration(Map<?, ?> map, Configuration def) {
        if (map == null) {
            return new Configuration(def);
        }
        return (Configuration)IReflection.getConstructor(Configuration.class, Map.class, Configuration.class).newInstance(map, def);
    }

    public static void notNull(Object object) {
        UTFConfiguration.notNull(object, "The validated object is null");
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public void save(Configuration config, File file) throws IOException {
        UTFConfiguration.notNull(file, "File cannot be null");
        Files.createParentDirs((File)file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);
        this.save(config, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Configuration config, Writer writer) {
        String data = this.writeExtras(this.saveToString(config));
        try {
            writer.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String saveToString(Configuration config) {
        String dump = this.yaml.get().dump(this.getSelf(config));
        if (dump.equals("{}\n")) {
            dump = "";
        }
        return dump;
    }

    private Configuration loadFromString(String contents, Configuration def) {
        UTFConfiguration.notNull(contents, "Contents cannot be null");
        this.loadExtras(contents);
        contents = contents.replaceFirst("~Config\n", "");
        Map input = (Map)this.yaml.get().load(contents);
        this.config = this.createConfiguration(input, def);
        this.removeUnused(def);
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration loadByString(Reader reader, Configuration def) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            String line;
            while ((line = input.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
        }
        return this.loadFromString(builder.toString(), def);
    }

    public Configuration load(File file) throws IOException {
        UTFConfiguration.notNull(file, "File cannot be null");
        return this.load(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));
    }

    public Configuration load(File file, Configuration defaults) throws IOException {
        UTFConfiguration.notNull(file, "File cannot be null");
        return this.load(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8), defaults);
    }

    public Configuration load(Reader reader) {
        try {
            return this.loadByString(reader, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.config = new Configuration();
            return this.config;
        }
    }

    public Configuration load(Reader reader, Configuration defaults) {
        try {
            return this.loadByString(reader, defaults);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.config = new Configuration();
            return this.config;
        }
    }

    public Configuration load(InputStream is) {
        return this.load(is, null);
    }

    public Configuration load(InputStream is, Configuration defaults) {
        try {
            return this.loadByString(new InputStreamReader(is), defaults);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.config = new Configuration();
            return this.config;
        }
    }

    public Configuration load(String string) {
        return this.load(string, null);
    }

    public Configuration load(String string, Configuration defaults) {
        return this.loadFromString(string, defaults);
    }

    public void removeUnused(Configuration origin) {
        if (origin == null) {
            return;
        }
        this.removeUnused("", this.config, origin);
    }

    private void removeUnused(String prefix, Configuration config, Configuration defaults) {
        Map<String, Object> data = this.getSelf(config);
        Map<String, Object> def = this.getSelf(defaults);
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : data.keySet()) {
            if (def.containsKey(key)) {
                Object baseValue = data.get(key);
                Object dataValue = def.get(key);
                if (!(dataValue instanceof Configuration) || !(baseValue instanceof Configuration)) continue;
                this.removeUnused(prefix + key + ".", (Configuration)baseValue, (Configuration)dataValue);
                continue;
            }
            toRemove.add(prefix + key);
        }
        for (String key : toRemove) {
            this.getConfig().set(key, null);
        }
        toRemove.clear();
    }

    public void deployExtras(String contents) {
        this.loadExtras(contents);
        this.deployedExtras = true;
    }

    private void loadExtras(String contents) {
        if (this.deployedExtras) {
            return;
        }
        this.extras.clear();
        int line = 0;
        String[] a = contents.split("\n", -1);
        int list = -1;
        for (int i = 0; i < a.length - 1; ++i) {
            String s = a[i];
            int empty = 0;
            while (s.startsWith(" ")) {
                s = s.substring(1);
                ++empty;
            }
            if (list > -1) {
                int n = list = list < empty ? list : -1;
                if (list > -1) continue;
            }
            if (s.startsWith("-")) {
                list = empty;
                continue;
            }
            if (this.isComment(a[i]) || this.isEmpty(a[i])) {
                this.extras.add(new Extra(a[i], line));
            }
            ++line;
        }
    }

    private boolean isComment(String s) {
        while (s.startsWith(" ")) {
            s = s.replaceFirst(" ", "");
        }
        return s.startsWith(COMMENT);
    }

    private boolean isEmpty(String s) {
        while (s.startsWith(" ")) {
            s = s.replaceFirst(" ", "");
        }
        return s.isEmpty() || s.equals("\n");
    }

    private String writeExtras(String contents) {
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(contents.split("\n", -1)));
        int size = lines.size() + this.extras.size();
        int e = 0;
        int listItems = 0;
        int list = -1;
        for (int i = 0; i < size && this.extras.size() != e; ++i) {
            if (lines.size() == i) {
                lines.add(this.extras.get(e++).getText());
                continue;
            }
            String s = (String)lines.get(i);
            int empty = 0;
            while (s.startsWith(" ")) {
                s = s.substring(1);
                ++empty;
            }
            if (list > -1) {
                int n = list = list < empty ? list : -1;
                if (list > -1) {
                    ++listItems;
                    continue;
                }
            }
            if (s.startsWith("-")) {
                ++listItems;
                list = empty;
                continue;
            }
            if (this.extras.get(e).getLine() != i - listItems) continue;
            lines.add(i, this.extras.get(e++).getText());
        }
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < lines.size(); ++j) {
            builder.append((String)lines.get(j));
            if (j >= lines.size() - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    public Configuration getConfig() {
        return this.config;
    }
}

