/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi.bungeecord.files;

import com.google.common.base.Charsets;
import de.codingair.tradesystem.lib.codingapi.bungeecord.files.loader.UTFConfiguration;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;

public class ConfigFile {
    private final UTFConfiguration configuration = new UTFConfiguration();
    private final String name;
    private final String path;
    private final String srcPath;
    private final Plugin plugin;

    public ConfigFile(String name, String path, String srcPath, Plugin plugin) {
        this.name = name;
        this.path = path;
        this.srcPath = srcPath == null ? "" : srcPath;
        this.plugin = plugin;
        try {
            this.load();
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ConfigFile(String name, String path, Plugin plugin) {
        this(name, path, "", plugin);
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    private File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        if (this.getDataFolder() == null || !this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        File file = new File(this.getDataFolder() + this.path, this.name + ".yml");
        InputStream in = this.plugin.getResourceAsStream(this.srcPath + this.name + ".yml");
        if (!file.exists()) {
            file.createNewFile();
            if (in != null) {
                FileOutputStream out = new FileOutputStream(file);
                this.copy(in, out);
                ((OutputStream)out).close();
            }
        }
        Configuration defaults = (in = this.plugin.getResourceAsStream(this.srcPath + this.name + ".yml")) == null ? null : this.configuration.load(in);
        this.configuration.load(file, defaults);
        if (defaults != null) {
            this.configuration.removeUnused(defaults);
            this.merge(this.configuration.getConfig(), defaults);
        }
        if ((in = this.plugin.getResourceAsStream(this.srcPath + this.name + ".yml")) != null) {
            InputStreamReader reader = new InputStreamReader(in, Charsets.UTF_8);
            BufferedReader input = new BufferedReader(reader);
            StringBuilder builder = new StringBuilder();
            try {
                try {
                    String line;
                    while ((line = input.readLine()) != null) {
                        builder.append(line);
                        builder.append('\n');
                    }
                }
                finally {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (builder.toString().startsWith("~Config\n")) {
                this.configuration.deployExtras(builder.toString());
            }
        }
        if (in != null) {
            in.close();
        }
    }

    private void merge(Configuration config, Configuration defaults) {
        Map<String, Object> data = this.getSelf(config);
        Map<String, Object> def = this.getSelf(defaults);
        for (String key : def.keySet()) {
            if (data.containsKey(key)) {
                Object baseValue = data.get(key);
                Object dataValue = def.get(key);
                if (!(dataValue instanceof Configuration)) continue;
                if (baseValue instanceof Configuration) {
                    this.merge((Configuration)baseValue, (Configuration)dataValue);
                    continue;
                }
                data.put(key, dataValue);
                continue;
            }
            data.put(key, def.get(key));
        }
    }

    private long copy(InputStream from, OutputStream to) throws IOException {
        if (from == null) {
            return -1L;
        }
        if (to == null) {
            throw new NullPointerException();
        }
        byte[] buf = new byte[4096];
        long total = 0L;
        int r;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public void save() {
        try {
            this.configuration.save(this.configuration.getConfig(), new File(this.getDataFolder(), this.path + this.name + ".yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Map<String, Object> getSelf(Configuration config) {
        IReflection.FieldAccessor self = IReflection.getField(Configuration.class, "self");
        return (Map)self.get(config);
    }

    public Configuration getConfig() {
        if (this.configuration.getConfig() == null) {
            try {
                this.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.configuration.getConfig();
    }

    public void clearConfig() {
        for (String key : this.getConfig().getKeys()) {
            this.getConfig().set(key, null);
        }
    }
}

