/*
 * Decompiled with CFR 0.152.
 */
package de.codingair.tradesystem.lib.codingapi;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.codingair.tradesystem.lib.codingapi.nms.NmsCheck;
import de.codingair.tradesystem.lib.codingapi.particles.animations.customanimations.AnimationType;
import de.codingair.tradesystem.lib.codingapi.player.Hologram;
import de.codingair.tradesystem.lib.codingapi.player.chat.ChatListener;
import de.codingair.tradesystem.lib.codingapi.player.gui.GUIListener;
import de.codingair.tradesystem.lib.codingapi.server.commands.builder.CommandBuilder;
import de.codingair.tradesystem.lib.codingapi.server.events.WalkListener;
import de.codingair.tradesystem.lib.codingapi.server.listeners.PickItemListener;
import de.codingair.tradesystem.lib.codingapi.server.reflections.IReflection;
import de.codingair.tradesystem.lib.codingapi.utils.Removable;
import de.codingair.tradesystem.lib.codingapi.utils.Ticker;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class API {
    private static final Cache<String, HashMap<Class<?>, Set<Removable>>> CACHE = CacheBuilder.newBuilder().build();
    private static final Cache<Class<?>, Set<Removable>> SPECIFIC = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private static final ConcurrentHashMap.KeySetView<Ticker, Boolean> TICKERS = ConcurrentHashMap.newKeySet();
    private static API instance;
    private boolean initialized = false;
    private final List<JavaPlugin> plugins = new ArrayList<JavaPlugin>();
    private BukkitTask tickerTimer = null;

    public void onEnable(JavaPlugin plugin) {
        if (!this.plugins.contains(plugin)) {
            this.plugins.add(plugin);
        }
        if (this.initialized) {
            return;
        }
        if (this.plugins.size() == 1) {
            this.initPlugin(plugin);
        }
    }

    public void onDisable(JavaPlugin plugin) {
        if (!this.initialized || !this.plugins.contains(plugin)) {
            return;
        }
        ArrayList<CommandBuilder> toDisable = new ArrayList<CommandBuilder>();
        List<CommandBuilder> l = API.getRemovables(null, CommandBuilder.class);
        for (CommandBuilder commandBuilder : l) {
            if (!commandBuilder.getPlugin().equals((Object)plugin)) continue;
            toDisable.add(commandBuilder);
        }
        l.clear();
        for (CommandBuilder b : toDisable) {
            b.unregister();
        }
        toDisable.clear();
        HandlerList.unregisterAll((Plugin)plugin);
        this.removePlugin(plugin);
        this.plugins.remove(plugin);
        if (!this.plugins.isEmpty()) {
            this.initPlugin(this.plugins.get(0));
        }
    }

    public void reload(JavaPlugin plugin) throws InvalidDescriptionException, FileNotFoundException, InvalidPluginException {
        ArrayList<JavaPlugin> plugins = new ArrayList<JavaPlugin>(this.plugins);
        for (JavaPlugin p : plugins) {
            if (p == plugin) continue;
            this.disablePlugin(p);
        }
        this.disablePlugin(plugin);
        this.enablePlugin(plugin.getName(), plugin);
        for (JavaPlugin p : plugins) {
            if (p == plugin) continue;
            this.enablePlugin(p.getName(), p);
        }
        plugins.clear();
    }

    public void disablePlugin(JavaPlugin plugin) {
        Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        try {
            IReflection.FieldAccessor lookupNames = IReflection.getField(SimplePluginManager.class, "lookupNames");
            IReflection.FieldAccessor plugins = IReflection.getField(SimplePluginManager.class, "plugins");
            Map map = (Map)lookupNames.get(Bukkit.getPluginManager());
            List pluginList = (List)plugins.get(Bukkit.getPluginManager());
            if (map.remove(plugin.getDescription().getName().toLowerCase()) == null) {
                map.remove(plugin.getDescription().getName());
            }
            pluginList.remove(plugin);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void enablePlugin(String name, JavaPlugin backup) throws InvalidDescriptionException, InvalidPluginException, FileNotFoundException {
        File pluginFile = new File("plugins", name + ".jar");
        if (!pluginFile.exists()) {
            File f = new File("plugins");
            for (File file : f.listFiles()) {
                if (file.isDirectory() || !file.getName().toLowerCase().contains(name.toLowerCase()) || !file.getName().endsWith(".jar")) continue;
                pluginFile = file;
                break;
            }
        }
        if (pluginFile.exists()) {
            Bukkit.getPluginManager().enablePlugin(Bukkit.getPluginManager().loadPlugin(pluginFile));
        } else {
            Bukkit.getPluginManager().enablePlugin((Plugin)backup);
        }
    }

    private void removePlugin(JavaPlugin plugin) {
        HandlerList.unregisterAll((Plugin)plugin);
        if (this.tickerTimer != null && this.tickerTimer.getOwner() == plugin) {
            this.tickerTimer.cancel();
            this.tickerTimer = null;
        }
        List<Removable> removables = API.getRemovables(plugin);
        removables.forEach(Removable::destroy);
        removables.clear();
        AnimationType.clearCache();
        if (plugin.equals((Object)GUIListener.getPlugin())) {
            GUIListener.setUnregistered();
        }
        this.initialized = false;
    }

    private void initPlugin(JavaPlugin plugin) {
        this.initialized = true;
        GUIListener.register((Plugin)plugin);
        Bukkit.getPluginManager().registerEvents(Hologram.getListener(), (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new WalkListener(), (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new ChatListener(), (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new PickItemListener(plugin), (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler(priority=EventPriority.HIGH)
            public void onQuit(PlayerQuitEvent e) {
                API.removeRemovables(e.getPlayer());
            }
        }, (Plugin)plugin);
        this.runTicker(plugin);
    }

    public void runTicker(JavaPlugin plugin) {
        if (this.tickerTimer != null) {
            return;
        }
        this.tickerTimer = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, new Runnable(){
            int i = 0;

            @Override
            public void run() {
                if (this.i == 20) {
                    TICKERS.forEach(t -> {
                        t.onTick();
                        t.onSecond();
                    });
                    this.i = 0;
                } else {
                    TICKERS.forEach(Ticker::onTick);
                    ++this.i;
                }
            }
        }, 0L, 1L);
    }

    public static API getInstance() {
        if (instance == null) {
            instance = new API();
        }
        return instance;
    }

    private static String getKey(Player player) {
        return player == null ? "\u00a7" : player.getName();
    }

    private static Class<?> getRemovableClass(Removable removable) {
        return API.getRemovableClass(removable.getClass());
    }

    private static Class<?> getRemovableClass(Class<?> c) {
        if (!API.containsRemovableInterface(c.getInterfaces())) {
            Class<?> deep = c.getSuperclass();
            if (deep == null) {
                return null;
            }
            Class<?> deeper = API.getRemovableClass(deep);
            return deeper == null ? c : deeper;
        }
        return c;
    }

    private static boolean containsRemovableInterface(Class<?>[] classes) {
        for (Class<?> aClass : classes) {
            if (!aClass.equals(Removable.class)) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean addRemovable(Removable removable) {
        HashSet<Removable> entries;
        Preconditions.checkNotNull((Object)removable);
        HashMap data = (HashMap)CACHE.getIfPresent((Object)API.getKey(removable.getPlayer()));
        Class<?> enclosingClass = API.getRemovableClass(removable);
        if (data == null) {
            data = new HashMap();
            entries = new HashSet<Removable>();
            data.put(enclosingClass, entries);
            CACHE.put((Object)API.getKey(removable.getPlayer()), data);
        } else {
            entries = (HashSet<Removable>)data.get(enclosingClass);
            if (entries == null) {
                entries = new HashSet();
                data.put(enclosingClass, entries);
            } else if (entries.contains(removable)) {
                return false;
            }
        }
        API.updateSpecific(removable, 1);
        entries.add(removable);
        return true;
    }

    public static synchronized <T extends Removable> T getRemovable(Player player, Class<? extends T> clazz) {
        Preconditions.checkNotNull(clazz);
        HashMap data = (HashMap)CACHE.getIfPresent((Object)API.getKey(player));
        if (data != null) {
            Set l = (Set)data.get(API.getRemovableClass(clazz));
            if (l != null) {
                for (Removable t : l) {
                    if (!clazz.isInstance(t)) continue;
                    return (T)t;
                }
            }
            return null;
        }
        return null;
    }

    public static synchronized <T extends Removable> T getRemovable(Class<? extends T> clazz, UUID uniqueId) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull((Object)uniqueId);
        HashMap data = (HashMap)CACHE.getIfPresent((Object)API.getKey(null));
        if (data == null) {
            return null;
        }
        Set entries = (Set)data.get(API.getRemovableClass(clazz));
        if (entries != null) {
            for (Removable entry : entries) {
                if (!entry.getUniqueId().equals(uniqueId)) continue;
                return (T)entry;
            }
        }
        return null;
    }

    private static synchronized List<Removable> getRemovables(JavaPlugin plugin) {
        ArrayList<Removable> found = new ArrayList<Removable>();
        ConcurrentMap data = CACHE.asMap();
        for (HashMap value : data.values()) {
            for (Set removables : value.values()) {
                for (Removable removable : removables) {
                    if (!removable.getPlugin().equals((Object)plugin)) continue;
                    found.add(removable);
                }
            }
        }
        return found;
    }

    public static synchronized <T extends Removable> List<T> getRemovables(Player player, Class<? extends T> clazz) {
        Preconditions.checkNotNull(clazz);
        HashMap data = (HashMap)CACHE.getIfPresent((Object)API.getKey(player));
        if (data != null) {
            Set entries = (Set)data.get(API.getRemovableClass(clazz));
            if (entries != null) {
                ArrayList<Removable> l = new ArrayList<Removable>();
                for (Object removable : entries) {
                    if (!clazz.isInstance(removable)) continue;
                    l.add((Removable)removable);
                }
                return l;
            }
            return new ArrayList();
        }
        return new ArrayList();
    }

    public static synchronized <T extends Removable> Set<T> getRemovables(Class<? extends T> clazz) {
        Preconditions.checkNotNull(clazz);
        HashSet<Removable> l = (HashSet<Removable>)SPECIFIC.getIfPresent(clazz);
        if (l != null) {
            return l;
        }
        l = new HashSet<Removable>();
        ConcurrentMap data = CACHE.asMap();
        Class<?> rClazz = API.getRemovableClass(clazz);
        for (HashMap value : data.values()) {
            Set r = (Set)value.get(rClazz);
            if (r == null) continue;
            for (Removable removable : r) {
                if (!clazz.isInstance(removable)) continue;
                l.add(removable);
            }
        }
        SPECIFIC.put(clazz, l);
        return l;
    }

    private static synchronized void updateSpecific(Removable r, int action) {
        Set l = (Set)SPECIFIC.getIfPresent(r.getClass());
        if (l == null) {
            return;
        }
        if (action == 1) {
            l.add(r);
        } else if (action == -1) {
            l.remove(r);
            if (l.isEmpty()) {
                SPECIFIC.invalidate(r.getClass());
            }
        }
    }

    public static synchronized boolean removeRemovable(Removable removable) {
        Class<?> enclosingClass;
        Set entries;
        Preconditions.checkNotNull((Object)removable);
        String key = API.getKey(removable.getPlayer());
        HashMap data = (HashMap)CACHE.getIfPresent((Object)key);
        if (data != null && (entries = (Set)data.get(enclosingClass = API.getRemovableClass(removable))) != null) {
            boolean success = entries.remove(removable);
            if (success) {
                API.updateSpecific(removable, -1);
                removable.destroy();
                if (entries.isEmpty()) {
                    data.remove(enclosingClass);
                    if (data.isEmpty()) {
                        CACHE.invalidate((Object)key);
                    }
                }
            }
            return success;
        }
        return false;
    }

    private static synchronized void removeRemovables(Player player) {
        String key = API.getKey(player);
        HashMap data = (HashMap)CACHE.getIfPresent((Object)key);
        CACHE.invalidate((Object)key);
        if (data != null) {
            data.values().forEach(s -> s.forEach(Removable::destroy));
        }
    }

    public static void addTicker(Ticker ticker) {
        TICKERS.add(ticker);
    }

    public static boolean removeTicker(Ticker ticker) {
        return TICKERS.remove(ticker);
    }

    public static boolean isRunning(Ticker t) {
        return TICKERS.contains(t);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public List<JavaPlugin> getPlugins() {
        return this.plugins;
    }

    public JavaPlugin getMainPlugin() {
        return this.plugins.isEmpty() ? null : this.plugins.get(0);
    }

    static {
        NmsCheck.testInternalApi();
    }
}

